import MaterialEditorService from "../services/MaterialEditorService.js";

export default class MaterialListCtrl {
	static $inject = ['materialList', 'materialEditorService', '$state'];
	static resolve = {
		materialList: ['materialEditorService', (materialEditorService) => materialEditorService.getMaterialList()]
	};

	materialEditorService;

	constructor(materialList, materialEditorService, $state) {
		this.materialEditorService = materialEditorService;
		this.materialList = materialList;
		this.$state = $state;
	}

	getMaterials() {
		return this.materialList;
	}

	changeState(material) {
		this.$state.go('materialeditor', { materialId: material.guid });
	}

	url(material) {
		return '#/mat/' + material.guid;
	}
}
