angular.module('overlay.broll', []).component('brollOverlay', {
    bindings: {
        overlayInfo: '<',
        config: '<',
        customConfig: '<',
    },
    templateUrl: 'src/components/brolloverlay/broll.overlay.html',
    controller: function($timeout) {
        var ctrl = this;

        this.$onInit = function() {
            $timeout(function() {
                var videoElem = document.querySelector('.broll-overlay-video');
                if (videoElem) {
                    videoElem.play().catch(function() {
                        videoElem.muted = true;
                        videoElem.play();
                    });
                }
            });
        }

        this.getVideoSrc = function() {
            var customConfigName = _.get(ctrl, 'config.customConfig');
            var fileName = _.get(ctrl, 'customConfig.overlays.broll.fileName');

            if (!customConfigName || !fileName) {
                return null;
            }

            return 'customize/' + customConfigName + '/videos/' + fileName;
        }
    }
});
