angular.module('overlay.countdown', []).component('countdownOverlay', {
    bindings: {
        overlayInfo: '<',
        config: '<',
        customConfig: '<',
    },
    templateUrl: 'src/components/countdownoverlay/countdown.overlay.html',
    controller: function(broadcastService, utilService, $interval, $scope, $timeout) {
        var ctrl = this;
        this.seriesColor = null;
        this.countdownInterval = null;
        this.countdownCounter = null;
        this.logos = [];

        this.$onInit = function() {
            var countdownSeconds = _.get(ctrl, 'customConfig.overlays.countdown.countdownSeconds');
            var backgroundVideo = _.get(ctrl, 'customConfig.overlays.countdown.backgroundVideo');

            if (countdownSeconds) {
                ctrl.countdownCounter = parseInt(countdownSeconds);
            }

            if (backgroundVideo) {
                $timeout(function() {
                    var videoElem = document.querySelector('.countdown-overlay-video');

                    if (videoElem) {
                        videoElem.play().catch(function() {
                            videoElem.muted =  true;
                            videoElem.play();
                        });
                    }
                });
            }
        }

        this.$onChanges = function(changes) {
            if (changes.overlayInfo) {
                if (changes.overlayInfo.currentValue.visible && this.countdownCounter > 0) {
                    if (!this.countdownInterval) {
                        startCountdown(parseInt(this.countdownCounter));
                    }
                }
            }

            if (changes.customConfig) {
                var seriesColor = _.get(changes, 'customConfig.currentValue.colors.series.backgroundColor');
                var logos = _.get(changes, 'customConfig.currentValue.overlays.countdown.logos');

                if (seriesColor) {
                    ctrl.seriesColor = utilService.hexToRgb(seriesColor);
                }

                if (logos && logos.length > 0) {
                    ctrl.logos = logos;
                }
            }
        }

        function startCountdown(duration) {
            ctrl.countdownCounter = duration;

            ctrl.countdownInterval = $interval(function() {
                ctrl.countdownCounter--;

                if (ctrl.countdownCounter <= 0) {
                    $scope.$emit('COUNTDOWN:REACHED_ZERO');
                    $interval.cancel(ctrl.countdownInterval);
                    ctrl.countdownInterval = null;
                }
            }, 1000);
        }

        this.displayCountdownValue = function() {
            if (ctrl.countdownCounter >= 600) {
                return utilService.secToString(ctrl.countdownCounter);
            }

            if (ctrl.countdownCounter >= 60) {
                return '0' + utilService.secToString(ctrl.countdownCounter);
            }

            if (ctrl.countdownCounter >= 10) {
                return '00:' + ctrl.countdownCounter;
            }

            if (ctrl.countdownCounter > 0) {
                return '00:0' + ctrl.countdownCounter;
            }

            return '00:00';
        }

        this.getBackgroundVideoSrc = function() {
            var customConfigName = _.get(ctrl, 'config.customConfig');
            var videoFileName = _.get(ctrl, 'customConfig.overlays.countdown.backgroundVideo');

            if (!customConfigName || !videoFileName) {
                return null;
            }

            return 'customize/' + customConfigName + '/videos/' + videoFileName;
        }

        this.getBackgroundImageSrc = function() {
            var customConfigName = _.get(ctrl, 'config.customConfig');
            var imageFileName = _.get(ctrl, 'customConfig.overlays.countdown.backgroundImage');

            if (!customConfigName || !imageFileName) {
                return null;
            }

            return 'customize/' + customConfigName + '/images/' + imageFileName;
        }

        this.getSeriesImageSrc = function() {
            var customConfigName = _.get(ctrl, 'config.customConfig');
            var seriesImageName = _.get(ctrl, 'customConfig.images.seriesBigImage');

            if (!customConfigName || !seriesImageName) {
                return broadcastService.getDefaultSeriesLogoUrl();
            }

            return 'customize/' + customConfigName + '/images/' + seriesImageName;
        }

        this.getLogoImageSrc = function(logoImageName) {
            var customConfigName = _.get(ctrl, 'config.customConfig');

            if (!customConfigName || !logoImageName) {
                return null;
            }

            return 'customize/' + customConfigName + '/images/' + logoImageName;
        }

        this.getDefaultSeriesLogoUrl = function() {
            return broadcastService.getDefaultSeriesLogoUrl();
        }
    }
});
