angular.module('entryInfo', ['VehicleInfoService']).component('entryInfo', {
    bindings: {
        entry: '<',
        selectedInfo: '<'
    },
    templateUrl: 'src/components/entryinfo/entryinfo.html',
    controller: function(vehicleInfoService) {
        var ctrl = this;

        this.getBigText = function() {
            var bigText;
            if (ctrl.selectedInfo === 'driverAndTeam' || ctrl.selectedInfo === 'driverAndDescription') {
                bigText = vehicleInfoService.getDriverNameOverride(ctrl.entry);
            } else if (ctrl.selectedInfo === 'teamAndDescription') {
                bigText = vehicleInfoService.getTeamNameOverride(ctrl.entry);
            }

            return bigText ? bigText : vehicleInfoService.getDriverNameOverride(ctrl.entry)
        }

        this.getSmallText = function() {
            var smallText;
            if (ctrl.selectedInfo === 'driverAndTeam') {
                smallText = vehicleInfoService.getTeamNameOverride(ctrl.entry);
            } else if (ctrl.selectedInfo === 'driverAndDescription') {
                smallText = vehicleInfoService.getDriverDescriptionOverride(ctrl.entry);
            } else if (ctrl.selectedInfo === 'teamAndDescription') {
                smallText = vehicleInfoService.getDriverNameOverride(ctrl.entry);
            }

            return smallText ? smallText : vehicleInfoService.getTeamNameOverride(ctrl.entry);
        }
    }
});
