angular.module('rf2.fallbackImage', []).directive('fallbackImage', function() {
    return {
        restrict: 'A',
        link: function($scope, $element, $attrs) {
            let hasSeenError = false;

            $attrs.$observe('fallbackImage', () => {
                hasSeenError = false;
            });

            const setFallbackImage = () => {
                if (hasSeenError) {
                    return;
                }

                hasSeenError = true; // Prevent infinite error loop if fallback image is not found.

                if ($attrs.fallbackImage) {
                    $element[0].src = $attrs.fallbackImage;
                }
            }

            $element[0].addEventListener('error', setFallbackImage);

            $scope.$on('$destroy', () => {
                $element[0].removeEventListener('error', setFallbackImage);
            });
        }
    }
});
