angular.module('partnerImages', []).component('partnerImages', {
    bindings: {
        config: '<',
        customConfig: '<',
        overlayInfo: '<'
    },
    templateUrl: 'src/components/partnerimages/partnerimages.html',
    controller: function($interval, $timeout, $http, broadcastService) {
        var ctrl = this;
        ctrl.cycleRightAdsInterval = null;
        ctrl.cycleRightAdIndex = null;
        ctrl.fadeOutRightAd = false;
        ctrl.fadeInRightAd = false;
        ctrl.leftAdImageSrc = null;
        ctrl.rightAdImageSrc = null;

        this.$onChanges = function(changes) {
            if (changes.customConfig && changes.customConfig.currentValue) {
                setAdImage('left', setLeftAdImageSrc, true);
                setAdImage('right', setRightAdImageSrc, false, true);
            }

            if (changes.overlayInfo) {
                var visibleNew = _.get(changes, 'overlayInfo.currentValue.visible');
                var visibleOld = _.get(changes, 'overlayInfo.previousValue.visible');

                if (visibleNew && !ctrl.cycleRightAdsInterval) {
                    ctrl.cycleRightAdIndex = null;
                    ctrl.startCyclingRightAds(
                        _.get(ctrl, 'customConfig.ads.rightCyclingAds'),
                        _.get(ctrl, 'customConfig.ads.rightCyclingAdsInterval')
                    );
                } else if (visibleNew === false && !visibleOld && ctrl.cycleRightAdsInterval) {
                    $interval.cancel(ctrl.cycleRightAdsInterval);
                    ctrl.cycleRightAdsInterval = null;
                }
            }
        }

        function setLeftAdImageSrc(src) {
            ctrl.leftAdImageSrc = src;
        }

        function setRightAdImageSrc(src) {
            ctrl.rightAdImageSrc = src;
        }

        function getSeriesImageSrc() {
            return '/framework/images/rfactor_2_racing_series_narrow.png';
        }

        function getSeriesImage(callbackFn) {
            var seriesImageSrc = getSeriesImageSrc();

            if (!seriesImageSrc) {
                callbackFn(null);
                return;
            }

            $http.get(seriesImageSrc).then(function() {
                callbackFn(seriesImageSrc);
            }).catch(function() {
                callbackFn(null);
            });
        }

        function setAdImage(which, callbackFn, useSeriesImageFallback, useGameLogoImageFallback = false) {
            var imageSrc = ctrl.getAdImageSrc(which);

            if (!imageSrc || imageSrc.length === 0) {
                if (useSeriesImageFallback) {
                    getSeriesImage(callbackFn);
                } else if (useGameLogoImageFallback) {
                    if (which === 'left') {
                        setLeftAdImageSrc(ctrl.getGameLogoSrc());
                    } else {
                        setRightAdImageSrc(ctrl.getGameLogoSrc());
                    }
                }
            } else {
                $http.get(imageSrc).then(function() {
                    ctrl[which + 'AdImageSrc'] = imageSrc;
                }).catch(function() {
                    if (useSeriesImageFallback) {
                        getSeriesImage(callbackFn);
                    }
                });
            }
        }

        this.getAdImageNameFromConfig = function(which) {
            if (which === 'right' && ctrl.cycleRightAdIndex !== null && ctrl.cycleRightAdIndex >= 0) {
                return _.get(ctrl, 'customConfig.ads.rightCyclingAds.' + ctrl.cycleRightAdIndex);
            }

            return _.get(ctrl, 'customConfig.ads.' + which + 'Ad');
        }

        this.getAdImageSrc = function(which) {
            var imageName = this.getAdImageNameFromConfig(which);
            var customConfigName = _.get(ctrl, 'config.customConfig');

            if (imageName && customConfigName) {
                if (customConfigName === 'default') {
                    return 'images/' + imageName;
                } else {
                    return 'customize/' + customConfigName + '/images/' + imageName;
                }
            }

            return '';
        }

        this.getGameLogoSrc = function() {
            if (ctrl.rightAdImageSrc === null) {
                ctrl.rightAdImageSrc = broadcastService.getGameLogoUrl();
            }

            return broadcastService.getGameLogoUrl();
        }

        this.startCyclingRightAds = function(rightCyclingAds, intervalDelay) {
            if (!rightCyclingAds || rightCyclingAds.length === 0) {
                return;
            }

            if (!intervalDelay || typeof intervalDelay !== 'number') {
                intervalDelay = 20000;
            }

            ctrl.cycleRightAdsInterval = $interval(function() {
                ctrl.fadeInRightAd = false;
                ctrl.fadeOutRightAd = true;

                $timeout(function() {
                    ctrl.cycleRightAdIndex = ctrl.getNextScrollingRightAdIndex(
                        rightCyclingAds,
                        ctrl.cycleRightAdIndex
                    );

                    setAdImage('right', setRightAdImageSrc, false);
                }, 500);

                $timeout(function() {
                    ctrl.fadeOutRightAd = false;
                    ctrl.fadeInRightAd = true;
                }, 1000);
            }, intervalDelay);
        }

        this.getNextScrollingRightAdIndex = function(cyclingRightAds, currentIndex) {
            if (!cyclingRightAds || cyclingRightAds.length === 0) {
                return null;
            }

            var nextIndex;

            if (currentIndex === null) {
                nextIndex = 0;
            } else if (currentIndex >= 0) {
                nextIndex = currentIndex + 1;
            }

            if (nextIndex === cyclingRightAds.length) {
                return null;
            }

            var nextImage = cyclingRightAds[nextIndex];

            if (!nextImage) {
                return null;
            }

            return nextIndex;
        }
    }
});
