angular.module('overlay.scheduleSlide', []).component('scheduleSlideOverlay', {
    bindings: {
        overlayInfo: '<',
        config: '<',
        customConfig: '<',
        schedule: '<'
    },
    templateUrl: 'src/components/scheduleslideoverlay/scheduleslide.overlay.html',
    controller: function() {
        var ctrl = this;
        this.leftListConfig = null;
        this.rightListConfig = null;

        this.$onChanges = function(changes) {
            if (changes.schedule)  {
                this.leftListConfig = getListConfig(changes.schedule.currentValue, 'left');
                this.rightListConfig = getListConfig(changes.schedule.currentValue, 'right');
            }
        }

        this.displayHeaderTopic = function() {
            var scheduleName = _.get(ctrl, 'customConfig.overlays.scheduleSlide.name');
            if (!scheduleName) {
                scheduleName = 'Schedule';
                var seasonName = _.get(ctrl, 'customConfig.seasonName');
                if (seasonName) {
                    scheduleName = seasonName + ' ' + scheduleName;
                }
            }

            return scheduleName;
        }

        function getListConfig(schedule, side = null) {
            if (!schedule || schedule.length === 0) {
                return null;
            }

            return {
                limitTo: getListLimitTo(side),
                startIndex: getListStartIndex(side),
                side: side === 'right' ? 'right' : 'left'
            }
        }

        function getListLimitTo(side) {
            if (!side) {
                return ctrl.schedule.length;
            }

            if (side === 'left') {
                return Math.ceil(ctrl.schedule.length / 2);
            }

            return Math.floor(ctrl.schedule.length / 2);
        }

        function getListStartIndex(side) {
            if (!side || side === 'left') {
                return 0;
            }

            var entryCount = _.get(ctrl, 'schedule.length');
            if (!entryCount) {
                return 0;
            }

            return Math.ceil(entryCount / 2);
        }
    }
});
