angular.module('overlay.sessionResults', ['VehicleInfoService']).component('sessionResultsOverlay', {
    bindings: {
        overlayInfo: '<',
        sessionResults: '<',
        sessionName: '<',
        config: '<',
        customConfig: '<',
        entryDataField: '<',
        selectedEntryInfo: '<',
        schedule: '<',
        sessionInfo: '<',
        cars: '<'
    },
    templateUrl: 'src/components/sessionresultsoverlay/sessionresults.overlay.html',
    controller: function(broadcastService, sessionService, standingsService, utilService, vehicleInfoService) {
        var ctrl = this;
        ctrl.displayedResults = [];
        ctrl.carImages = [];

        this.$onChanges = function(changes) {
            if (changes.sessionResults && changes.sessionResults.currentValue) {
                var results = changes.sessionResults.currentValue;
                results = _.orderBy(results, 'position');

                if (!broadcastService.isMixedClassMode(ctrl.getSelectedCarClass())) {
                    results = _.filter(results, { carClass: ctrl.getSelectedCarClass() });
                }

                _.forEach(results, function(entry, index) {
                    entry.resultsPosition = index + 1;
                });

                ctrl.displayedResults = results;

                _.forEach(ctrl.sessionResults, function(entry) {
                    if (!_.find(ctrl.carImages, { vehicleFilename: entry.vehicleFilename })) {
                        broadcastService.getDiskOrGameCarImageSrc(
                            entry,
                            _.get(ctrl, 'config.customConfig'),
                            setEntryCarImageSrc
                        );
                    }
                });
            }
        };

        function setEntryCarImageSrc(src, entry) {
            if (src && entry) {
                ctrl.carImages.push({
                    vehicleFilename: entry.vehicleFilename,
                    carImageSrc: src
                });
            }
        }

        this.hasCarNumberWithThreeChars = function(results) {
            if (!results || results.length === 0) {
                return false;
            }

            for (var i = 0; i < results.length; i++) {
                var carNumber = vehicleInfoService.getCarNumberOverride(results[i]);

                if (carNumber && carNumber.length === 3) {
                    return true;
                }
            }

            return false;
        }

        this.displayHeaderTopic = function() {
            if (ctrl.overlayInfo && ctrl.overlayInfo.key === 'midraceResults') {
                return 'Current standings';
            }

            var sessionType = sessionService.getSessionType(ctrl.sessionName);

            if (!sessionType) {
                return 'Results';
            }

            return sessionType;
        }

        this.getDriversPerPage = function() {
            return _.get(ctrl, 'overlayInfo.settings.driversPerPage');
        }

        this.getPage = function() {
            return _.get(ctrl, 'overlayInfo.settings.page');
        }

        this.getLimitTo = function() {
            var driversPerPage = ctrl.getDriversPerPage();

            if (!driversPerPage) {
                return 10;
            }

            return driversPerPage;
        }

        this.getStartIndex = function() {
            var page = ctrl.getPage();
            var driversPerPage = ctrl.getDriversPerPage();

            if (!page || !driversPerPage) {
                return 0;
            }

            return (page - 1) * driversPerPage;
        }

        this.getDynamicRowCount = function() {
            return Math.min(
                ctrl.displayedResults.length - ctrl.getStartIndex(),
                ctrl.getDriversPerPage()
            );
        }

        this.getSelectedCarClass = function() {
            return _.get(ctrl, 'overlayInfo.settings.selectedCarClass');
        }

        this.getCssCarClassName = function(carClass) {
            return utilService.generateCssCarClassName(carClass);
        }

        this.getDriverBorderLeftStyle = function(driver) {
            var style = broadcastService.getDriverBorderStyle(
                driver,
                ctrl.customConfig,
                'borderLeft'
            );

            if (!style) {
                return null;
            }

            return style.borderLeft;
        }

        this.displayCarNumber = function(driver) {
            return vehicleInfoService.getCarNumberOverride(driver);
        }

        this.getCarNumberStyle = function(driver) {
            return broadcastService.getCarClassColorStyle(driver, ctrl.customConfig, 'color');
        }

        this.getCarImageSrc = function(driver) {
            var entry = _.find(ctrl.carImages, { vehicleFilename: driver.vehicleFilename });

            if (!entry) {
                return null;
            }

            return entry.carImageSrc;
        }

        this.displayBestLapTime = function(driver) {
            const positionProp = broadcastService.isMixedClassMode(ctrl.getSelectedCarClass())
              ? 'position'
              : 'classPosition';
            
            if (driver[positionProp] == 1) {
                return standingsService.formatDriverLapTime(driver, 'bestLapTime');
            }
            return '';
        }

        this.displayGap = function(driver) {
            const isMixedClassMode = broadcastService.isMixedClassMode(ctrl.getSelectedCarClass());
            const positionProp = isMixedClassMode ? 'position' : 'classPosition';

            if (sessionService.getSessionType(ctrl.sessionName) === 'RACE') {
                if (standingsService.isDriverDnf(driver)) {
                    return 'DNF';
                }
                
                if (standingsService.isDriverDq(driver)) {
                    return 'DQ';
                }

                const winner = _.find(ctrl.displayedResults, { [positionProp]: 1 });

                if (driver.lapsCompleted !== winner.lapsCompleted) {
                    const lapsBehind = winner.lapsCompleted - driver.lapsCompleted;

                    return '+' + lapsBehind + (lapsBehind === 1 ? ' lap' : ' laps');
                } else {
                    if (driver === winner) {
                        const lc = driver.lapsCompleted;

                        return lc + (lc === 1 ? ' lap' : ' laps');
                    } else {
                        const getTimeDiff = () => {
                            if (ctrl.overlayInfo.key === 'midraceResults') {
                              return isMixedClassMode ? driver.timeBehindLeader : driver.timeBehindLeaderInClass;
                            } else {
                              return driver.finishTime - winner.finishTime;
                            }
                          }
  
                          return standingsService.formatLapTimeDiff(getTimeDiff());                    
                        }
                }
            } else {
                if (driver[positionProp] === 1) {
                    return '';
                }

                var leader = _.find(ctrl.displayedResults, { [positionProp]: 1 });
                var lapTimeDiff = standingsService.getLapTimeDiff(leader, driver, 'bestLapTime');

                return standingsService.formatLapTimeDiff(lapTimeDiff);
            }
        }

        this.isRaceResult = function() {
            return sessionService.isRaceSession({ session: ctrl.sessionName });
        }
    }
}).filter('sessionResultsPage', function () {
    return (items, page, perPage) => {
        if (page > 1) {
            items.splice(0, (page - 1) * perPage);
        }

        return items;
    }
});
