angular.module('controlpanel.startingOrderSettings', ['BroadcastService']).component('startingOrderSettings', {
    bindings: {
        settings: '<',
        startingOrder: '<',
        updateSettings: '&'
    },
    templateUrl: 'src/components/startingordersettings/startingordersettings.html',
    controller: function(broadcastService) {
        var ctrl = this;
        this.carClasses = [];

        this.$onChanges = function(changes) {
            if (changes.settings && changes.settings.currentValue) {
                var settingsSelectedCarClass = getSelectedCarClass();
                if (settingsSelectedCarClass) {
                    if (ctrl.carClasses
                        && ctrl.carClasses.length > 0
                        && (!_.includes(ctrl.carClasses, settingsSelectedCarClass))
                    ) {
                        var isMixedClassMode = broadcastService.isMixedClassMode(settingsSelectedCarClass);
                        if (!selectFirstCarClass() && !isMixedClassMode) {
                            resetSettings();
                        }
                    }
                } else {
                    selectFirstCarClass();
                }
            }

            if (changes.startingOrder) {
                ctrl.carClasses = _.uniq(_.map(changes.startingOrder.currentValue, 'carClass'));
            }
        }

        function getSelectedCarClass() {
            return _.get(ctrl, 'settings.selectedCarClass');
        }

        function selectFirstCarClass() {
            var firstCarClass = _.get(ctrl, 'carClasses.0');
            if (!firstCarClass || broadcastService.isMixedClassMode(getSelectedCarClass())) {
                return false;
            }

            try {
                ctrl.settings.selectedCarClass = firstCarClass;
                ctrl.update();
                return true;
            } catch (e) {
                return false;
            }
        }

        this.onSelectedCarClassChanged = function() {
            if (ctrl.settings && ctrl.settings.selectedCarClass) {
                this.update();
            }
        }

        function resetSettings() {
            ctrl.updateSettings({ settings: { selectedCarClass: null } });
        }

        this.update = function() {
            if (!ctrl.settings) {
                return;
            }

            ctrl.updateSettings({ settings: ctrl.settings });
        }
    }
});
