angular.module('ControlPanelService', []).service('controlPanelService', function() {
    var settingGroupStorageKey = 'rf2.overlay.controlpanel.settingGroups';
    var service = {
        getDefaultSettingGroupConfig: getDefaultSettingGroupConfig,
        initSettingGroups: initSettingGroups,
        storeSettingGroups: storeSettingGroups,
        getStoredSettingGroups: getStoredSettingGroups,
        checkStoredSettingGroups: checkStoredSettingGroups
    }

    return service;

    function getDefaultSettingGroupConfig() {
        return [
            {
                name: 'Config',
                minimized: false
            },
            {
                name: 'Clients',
                minimized: false
            },
            {
                name: 'Timing',
                minimized: false
            },
            {
                name: 'Data controls',
                minimized: false
            },
            {
                name: 'Banner & tower',
                minimized: false
            },
            {
                name: 'Driver box & qualifying',
                minimized: false
            },
            {
                name: 'On-board',
                minimized: false,
            },
            {
                name: 'Battle boxes',
                minimized: false
            },
            {
                name: 'Intro',
                minimized: false
            },
            {
                name: 'Starting order',
                minimized: false
            },
            {
                name: 'Show replay',
                minimized: false
            },
            {
                name: 'Session results',
                minimized: false
            },
            {
                name: 'Mid-race results',
                minimized: false
            },
            {
                name: 'Season standings',
                minimized: false
            },
            {
                name: 'In-race season standings',
                minimized: false
            }
        ]
    }

    function initSettingGroups() {
        var defaultSettingGroups = getDefaultSettingGroupConfig();
        var storedSettingGroupsJson = getStoredSettingGroups();
        if (storedSettingGroupsJson) {
            var storedSettingGroups = JSON.parse(storedSettingGroupsJson);
            checkStoredSettingGroups(storedSettingGroups, defaultSettingGroups);

            return storedSettingGroups;
        }

        return defaultSettingGroups;
    }

    function storeSettingGroups(settingGroups) {
        localStorage.setItem(settingGroupStorageKey, JSON.stringify(settingGroups));
    }

    function getStoredSettingGroups() {
        return localStorage.getItem(settingGroupStorageKey);;
    }

    // Check stored setting groups and add any default group that is not already there
    function checkStoredSettingGroups(storedSettingGroups, defaultSettingGroups) {
        var foundNewGroups = false;
        _.forEach(defaultSettingGroups, function(defaultSettingGroup) {
            var foundStoredSettingGroup = _.find(storedSettingGroups, { name: defaultSettingGroup.name });
            if (!foundStoredSettingGroup) {
                foundNewGroups = true;
                storedSettingGroups.push(defaultSettingGroup);
            }
        });

        if (foundNewGroups) {
            storeSettingGroups(storedSettingGroups);
        }
    }
});
