angular.module('VehicleInfoService', []).service('vehicleInfoService', function(
    $http,
    $q
) {
    var vehicleOverrideInfo = null;

    return {
        getVehicleOverrideInfo,
        setVehicleOverrideInfo,
        getDriverOverrideInfo,
        getTeamOverrideInfo,
        getDriverOverrideField,
        getTeamOverrideField,
        getCarNumberOverride,
        getDriverNameOverride,
        getDriverDescriptionOverride,
        getTeamNameOverride,
        getTeamDescription,
        getDriverFirstName,
        getDriverLastName,
        getVehicleName
    };

    function getVehicleOverrideInfo(customConfigName) {
        if (!customConfigName) {
            return $q.reject();
        }

        let overrideFileName = 'vehicle_info_override.json';
        return $http.get('customize/' + customConfigName + '/' + overrideFileName).then(function(response) {
            vehicleOverrideInfo = response.data;

            return response.data;
        });
    }

    function setVehicleOverrideInfo(overrideInfo) {
        vehicleOverrideInfo = overrideInfo;
    }

    function getDriverOverrideInfo(entry) {
        if (!vehicleOverrideInfo) {
            return null;
        }

        var driverOverrideInfo = null;
        var vehicleOverride = vehicleOverrideInfo[entry.vehicleFilename];
        _.forEach(vehicleOverride, function(overrideEntry) {
            if (overrideEntry.match && overrideEntry.match['Driver'] === entry.driverName) {
                driverOverrideInfo = overrideEntry['override'];
                return false;
            }
        });

        return driverOverrideInfo;
    }

    function getTeamOverrideInfo(entry) {
        if (!vehicleOverrideInfo) {
            return null;
        }

        var teamOverrideInfo = null;
        var vehicleOverride = vehicleOverrideInfo[entry.vehicleFilename];
        _.forEach(vehicleOverride, function(overrideEntry) {
            if (overrideEntry.match && overrideEntry.match['FullTeamName'] === entry.fullTeamName) {
                teamOverrideInfo = overrideEntry['override'];
                return false;
            }
        });

        return teamOverrideInfo;
    }

    function getDriverOverrideField(entry, fieldPath) {
        try {
            return _.get(getDriverOverrideInfo(entry), fieldPath);
        } catch (e) {
            return null;
        }
    }

    function getTeamOverrideField(entry, fieldPath) {
        try {
            return _.get(getTeamOverrideInfo(entry), fieldPath);
        } catch (e) {
            return null;
        }
    }

    function getCarNumberOverride(entry) {
        if (!entry) {
            return '';
        }

        var carNumber = entry['carNumber'];
        var overrideDriverCarNumber = getDriverOverrideField(entry, 'Number');
        if (overrideDriverCarNumber) {
            carNumber = overrideDriverCarNumber;
        } else {
            var overrideTeamCarNumber = getTeamOverrideField(entry, 'Number');
            if (overrideTeamCarNumber) {
                carNumber = overrideTeamCarNumber;
            }
        }

        return carNumber;
    }

    function getDriverNameOverride(entry) {
        if (!entry) {
            return '';
        }

        var driverName = entry.driverName;
        var overrideDriverName = getDriverOverrideField(entry, 'Driver')
        if (overrideDriverName) {
            driverName = overrideDriverName;
        }

        if (driverName) {
            return driverName.trim();
        } else {
            return driverName;
        }
    }

    function getDriverDescriptionOverride(entry) {
        if (!entry) {
            return '';
        }

        var driverDescription = entry.vehicleName;
        var overrideDriverDescription = getDriverOverrideField(entry, 'Description')
        if (overrideDriverDescription) {
            driverDescription = overrideDriverDescription;
        }

        return driverDescription;
    }

    function getTeamNameOverride(entry) {
        if (!entry) {
            return '';
        }

        var teamName = entry.fullTeamName;
        var overrideDriverTeamName = getDriverOverrideField(entry, 'FullTeamName');
        if (overrideDriverTeamName) {
            teamName = overrideDriverTeamName;
        } else {
            var overrideTeamName = getTeamOverrideField(entry, 'FullTeamName');
            if (overrideTeamName) {
                teamName = overrideTeamName;
            }
        }

        return teamName;
    }

    function getTeamDescription(entry) {
        if (!entry) {
            return '';
        }

        var teamDescription = entry.vehicleName;
        var driverTeamDescription = getDriverOverrideField(entry, 'teamDescription');
        if (driverTeamDescription) {
            teamDescription = driverTeamDescription;
        } else {
            var overrideTeamDescription = getTeamOverrideField(entry, 'description');
            if (overrideTeamDescription) {
                teamDescription = overrideTeamDescription;
            }
        }

        return teamDescription;
    }

    function getDriverFirstName(name) {
        if (!name) {
            return '';
        }

        var spaceIndex = name.indexOf(' ');
        if (spaceIndex === -1) {
            return name;
        }

        var firstName = name.slice(0, spaceIndex);
        if (!firstName) {
            return name;
        }

        return firstName;
    }

    function getDriverLastName(name) {
        if (!name) {
            return '';
        }

        var spaceIndex = name.indexOf(' ');
        if (spaceIndex === -1) {
            return name;
        }

        var lastName = name.slice(spaceIndex + 1, name.length);
        if (!lastName) {
            return name;
        }

        return lastName;
    }

    function getVehicleName(entry) {
        if (!entry) {
            return '';
        }

        return entry.vehicleName;
    }
});
