# Gameplay
Difficulty settings control various driving aids that make it easier for you to drive your car. In addition, there are settings affecting your car's damage sensitivity as well as some general settings for the way AI-controlled opponents behave when you are practicing or racing solo.

The replay functionality in rFactor 2 allows you to record your races and play them back to take another look at what happened during the race. Since you can change your camera views during the replay, irrespective of what you were seeing during the race, this can really help to give you a better understanding of your performance.

## Difficulty

### Preset
This setting lets you quickly change between different levels of driving aids.

Note that loading a controller profile in 'Calibrate controls' will change these settings and set the preset to 'Custom'.

### Damage multiplier
This setting lets you adjust how much damage your car sustains in collisions and crashes.

### AI strength
This setting determines the relative speed with which AI-controlled opponents will race you. That speed is calculated taking your car and the track you race on into account. It may take some experimenting with this slider to find the best level of AI strength to practice against.

### AI aggression
This setting determines how aggressively the AI-controlled opponents race against you, for instance in the way they take corners and overtake you.

### Driving line
The driving line aid has options to lead you out of the rear paddock to the pit lane, to show the direction to the pits on a scheduled stop or to just be on all the time. When enabled all the time the driving line can help you learn a new track faster. It will show you the racing line and change color dynamically between green if you need to speed up, and red if you need to slow down. 

### Steering help
This setting determines how assistance you get when steering. Steering help will try to keep your car closer to the ideal line when your own steering would cause it to veer away from it. Note that steering assist doesn't take any AI opponents into account and may cause you to crash into AI-controlled cars around you on the track. There are 4 options: 'Off' disables all steering assist, 'Low', 'Medium' and 'High' determine how much steering assist you will be given.

### Opposite lock
When turned 'On', this setting prevents your car from breaking into a spin when your driving would otherwise cause it to do so.

### Braking help
This settings, like the steering assist, helps you keep your car on the ideal line. Note that the actual braking behaviour of the braking assist function takes your car's characteristics into account when calculating when to brake and how much. This means that actual braking timing and force will be different for different cars. This setting has 4 options: 'Off' disables the braking help, 'Low', 'Medium' and 'High' determine how much assistance you will get.

### Stability control
This setting, when turned 'On', helps you keep your control under control by applying the brakes when your car starts slipping and you are not accelerating.

### Spin recovery
When turned 'On', this setting helps you put your car back on the track facing the right direction after you have spun out of control.

### Invulnerability
This setting, when turned 'On', ignores any damage your car would normally sustain from crashed and collisions. It doesn't stop your car from building up the normal wear and tear, such as the tires wearing out over time.

### Auto shifting
This setting determines the auto shift function of your car, irrespective of your car's make and model's actual auto shift ability. In other words: even if our car doesn't support this function in reality, you can turn this function on here to assist you when driving.
This setting has 4 settings: 'Off' - no auto shifting enabled; 'Upshifts' - automatically shifting gears up; 'Downshifts' - automatically shifting gears down; 'On' automatically shifting gears both up and down.

### Traction control
This settings is comparable to Stability control, as it helps you keep control over your car. Instead of applying the brakes, however, this function limits the amount of acceleration applied to just under the level at which you car's wheels would lose traction with the track's surface. Note that most modern cars have this function built in, and allow more fine-grained controls over the way it works. For those cars, it's better to fine-tune the settings for this function in the garage settings specific to your car's make and model. The traction control provided by this setting is a general assist function that also works for cars that do not come factory equiped with this.
This setting has 4 options: 'Off' to disable traction control; 'Low', 'Medium', and 'High' to set the level of assist you will get.

### Anti-lock brakes
This setting controls a form of stability assist that modified the braking force applied to prevent your wheels from losing grip on the track's surface. See also the comments for the Traction control setting.

### Auto pit lane
This setting determines the behaviour of your car when visiting the pit. When set to 'On' your car will be driven automatically, which helps you avoid disqualification for driving too fast or for bumping into competitors leaving their station.

### Auto clutch
This setting toggles the function that can automatically engage the clutch when shifting gears, to prevent you from blowing up or stalling your engine.

### Auto blip
This setting, when turned 'On', smooths out the engine's revs by accelerating slightly after shifting down. This prevents the car from being slowed by the engine as it adjusts to the new gear ratio.

### Auto lift
Whether to automatically lift with manual shifting but auto-clutching (non-semiautomatic trans only).

### Hold brakes
This will make rFactor 2 hold the brakes for you until you press any pedal after you press drive.

### Hold clutch
This will make rFactor 2 hold the clutch for you until you press any pedal after you press drive.

### Repeat shifts
This adds a minimum delay required to register a second shift after shifting up or down. This can help when your device registers double inputs when shifting.

### Auto start engine
When turned 'On', this setting automatically restarts the engine after stalling.

### Auto windscreen wipers
This setting, when turned 'On', automatically turns o the windscreen wipers when it starts raining.

### Auto headlights
This setting, when turned 'On', automatically turns on the headlights when it gets dark.

### Auto reverse
If auto-shifting and holding brakes, will shift into reverse, and reverse throttle and brake temporarily.

## Replays

### Record replays
When set to ' On', replay information is recorded.

### Replay fidelity
This setting determines how much detail is recorded for replay. This is trade-off between the realism of the replay and the size of the file being created: more detail takes up more storage space, so you may have to use a lower setting when your disk space is limited.

### Record hot laps
When this setting is set to 'On', the fastest lap in a session will be recorded, even when 'Record replay' is set to 'Off'. When both are set to 'On', all laps will be recorded, with an extra recording of the fastest lap for direct access. When both are set to 'Off', nothing will be recorded.

### Instant replay
This setting determines how many seconds back in time the replay starts when you press the 'instant replay' control during a race (you can find this control in 'Assign controls' in the 'Gameplay' section of the 'Assists & gameplay' tab). Note that this setting also determines how far back in time the replay starts when you enter the garage and press Escape (ESC).

## Network

### Connection type
### Upstream
### Downstream
These settings allow you to limit the throughput over your network, both upstream and downstream. As the available bandwidth of modern Internet connections keeps growing, its very likely you will never have to touch these settings. Most Internet connections nowadays are more than adequate to handle the amount of data rFactor 2 requires. Should you find, however, that rFactor 2 is using more bandwidth than you want (for instance when other people are using the same network) you can use these settings to make rFactor 2 behave a little bit more network-friendly.

Do not go lower than 512Kbps when you are racing in an international league.

It's highly unlikely you will ever need more than 20Mbps for almost all situations.

## Plugins

### Plugin
These settings are specific for the plugins you have added to your rFactor 2 environment. Only the plugins found when starting rFactor 2 will be shown here. When you change any of these settings those changes will only come into effect after restarting the game.