# Sound
Before we look at the settings provided under the 'Sound' tab of the Setup screen, it may be a good idea to check your Windows sound settings. The main thing to check is the relative volume of rFactor 2 in Window's Volume Mixer. If that is set to maximum, you may find the in-game sounds of rFactor 2 drowning out all other sounds. If you are using live chats, for instance, you want to be able to hear that at least as loud as the game's sounds.

Overall, a proper sound card and a decent pair of studio headphones will give you the most realistic sound and be better for your ears and comfort, especially during those long races.

Note: some settings will not be available during an event.

## Sound volume

### Master volume
This setting adjusts the volume of everything.

### Onboard volume
This setting adjusts how loud you hear everything when in a cockpit camera. This can be used to turn down the game's volume while driving without turning down the volume from TV cameras.

### Spotter volume
This setting adjusts the relative volume of the spotter's voice: the voice that announces your lap times and other information over the in-car radio. You should set this to a level at which the voice is audible but doesn't drown out the other sounds in the game.

### UI music volume
This setting adjusts the volume of the main menu ambient music.

### UI button click volume
This setting adjusts the volume when clicking on buttons across the UI.

### UI button hover volume
This setting adjusts the volume when hovering over buttons across the UI.

## Legacy settings

### Sound effects volume
This setting lets you adjust the relative volume of the sounds effects in the game for interactions between your car and the environment, such as bumps and crashes. Note that this setting only affects cars build for the old sound engine.

### Engine volume
This setting lets you adjust the relative volume of the noise the engines makes. This affects the loudness of the engine as heard both from inside the car and outside the car. Note that this setting only affects cars build for the old sound engine.

### Tire volume
This setting lets you adjust the relative volume the tires make. Note that this setting only affects cars build for the old sound engine.

### External volume ratio
This setting adjusts the balance between external and onboard volume. This can be used to boost or attenuate other cars when driving.

## Sound configuration

### Number of effects
This determines the number of voices that are used simultaneously for producing sound. Usually it is fine to use the full maximum of 256. If you hear sounds disappearing, increase this. If you experience strong crackling and similar sound issues, decrease this.

### Spotter detail
This setting lets you adjust the number of things the spotter informs you about. This ranges from no information at all (Off) to a lot of information about other cars, relative positions, and other details about the current race.

### Spotter lap times
This setting lets you choose how often the spotter informs you of your lap times. If set to 'Never' you don't get any lap time information. If set to 'Except For Race', the spotter informs you of your lap times while practicing but not during races, so as not to distract you. If set to 'Always' the spotter will always inform you about your lap times.

### Speaker configuration
This setting lets you select the speakers or headphones setup you are using, to ensure the best possible sound quality for your setup. Headphones setups will automatically enable HRTF for a binaural experience.

### HRTF selection
This setting lets you choose a HRTF. HRTFs are responsible for creating 3D binaural sound and rely on the head shape of the user. For this reason, there is no one-fits-all solution. If you get the impression that sounds that should be in front of you or behind you are actually above or below you, change this setting. You can also add your own personal HRTF to the game and select it here.

### Trackside mode
This setting adjusts how you hear the world from trackside cameras. In Broadcast mode, you will hear sound as if it was recorded from static microphones at trackside, like they are used in broadcasts. This will give you a strong panning effect as cars pass by. In Immersive mode, you will hear the world how you see it, as if you are standing trackside yourself.